﻿using System;
using System.Drawing.Imaging;
using System.Drawing;
using System.Drawing.Design;
using System.Drawing.Text;
using System.Security.Cryptography;
using System.Web.UI;
using System.Web;

// ***************************************************************************************
// *** Image Verify Class ***
// *** Original Author: Vadivel Kumar ***
// *** Retrieved From: http://www.codeproject.com/KB/web-image/ImageVerification.aspx ***
// *** Original Language: C# ***
// ***************************************************************************************

public class CImgVerify
{
    public CImgVerify()
    {
    }

    /// <summary> 
    /// The function <c>getRandomAlphaNumeric</c> will return the string 
    /// generated by the <c>RandomNumberGenerator</c> class. This will be used 
    /// to make the string value. The function will check whether the randomnly 
    /// generated numerics are falling into 32 to 127 for making 
    /// it as a character. If the value returned is not in the range 
    /// then that we will be used as it is. By default, the randomnly generated number 
    /// array will hold 3 elements. 
    /// </summary> 
    /// <returns>string value, which is the randomnly generated alphanumeric value</returns> 
    public string getRandomAlphaNumeric()
    {

        RandomNumberGenerator rm = default(RandomNumberGenerator);
        rm = RandomNumberGenerator.Create();

        byte[] data = new byte[3];

        rm.GetNonZeroBytes(data);

        string sRand = "";
        string sTmp = "";
        for (int nCnt = 0; nCnt <= data.Length - 1; nCnt++)
        {

            int nVal = Convert.ToInt32(data.GetValue(nCnt));

            if (nVal > 32 && nVal < 127)
            {
                sTmp = Convert.ToChar(nVal).ToString();
            }
            else
            {
                sTmp = nVal.ToString();
            }

            sRand += sTmp.ToString();
        }

        return sRand;
    }

    public Bitmap generateImage(string sTextToImg)
    {
        PixelFormat pxImagePattern = PixelFormat.Format32bppArgb;
        Bitmap bmpImage = new Bitmap(1, 1, pxImagePattern);
        Font fntImageFont = new Font("Trebuchets", 14);
        Graphics gdImageGrp = Graphics.FromImage(bmpImage);

        float iWidth = gdImageGrp.MeasureString(sTextToImg, fntImageFont).Width;
        float iHeight = gdImageGrp.MeasureString(sTextToImg, fntImageFont).Height;

        bmpImage = new Bitmap((int)iWidth, (int)iHeight, pxImagePattern);

        gdImageGrp = Graphics.FromImage(bmpImage);
        gdImageGrp.Clear(Color.White);

        gdImageGrp.TextRenderingHint = TextRenderingHint.AntiAlias;

        gdImageGrp.DrawString(sTextToImg, fntImageFont, new SolidBrush(Color.Red), 0, 0);
        gdImageGrp.Flush();

        return bmpImage;
    }
}
